<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

use App\Repository\AnyoneSharesRepository;

#[ORM\Entity(repositoryClass: AnyoneSharesRepository::class)]
#[ORM\Table(name: "anyone_shares")]
class AnyoneShares
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: "integer")]
    private int $id;

    #[ORM\Column(type: "string", length: 255)]
    private string $owner;

    #[ORM\Column(type: "string", length: 255)]
    private string $sharedWith;

    #[ORM\Column(type: "boolean")]
    private bool $active;

    public function getId(): int
    {
        return $this->id;
    }

    public function getOwner(): string
    {
        return $this->owner;
    }

    public function setOwner(string $owner): self
    {
        $this->owner = $owner;
        return $this;
    }

    public function getSharedWith(): string
    {
        return $this->sharedWith;
    }

    public function setSharedWith(string $sharedWith): self
    {
        $this->sharedWith = $sharedWith;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;
        return $this;
    }
}