<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: AliasRepository::class)]
#[ORM\Table(name: 'alias')]
class Alias
{
    #[ORM\Id]
    #[ORM\Column(type: 'string', length: 255)]
    #[ORM\GeneratedValue(strategy: 'NONE')]
    private string $address;

    #[ORM\Column(type: 'string', length: 255)]
    private string $name;

    #[ORM\Column(type: 'string', length: 30)]
    private string $accessPolicy;

    #[ORM\Column(type: 'string', length: 255)]
    private string $domain;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    private \DateTime $created;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    private \DateTime $modified;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    private \DateTime $expired;

    #[ORM\Column(type: 'boolean')]
    private bool $active;
}