<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity]
#[ORM\Table(name: 'deleted_mailboxes')]
class DeletedMailboxes
{
    #[ORM\Id]
    #[ORM\Column(type: 'bigint')]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private int $id;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    private \DateTime $timestamp;

    #[ORM\Column(type: 'string', length: 255)]
    private string $username;

    #[ORM\Column(type: 'string', length: 255)]
    private string $domain;

    #[ORM\Column(type: 'string', length: 255)]
    private string $maildir;

    #[ORM\Column(type: 'string', length: 255)]
    private string $admin;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, options: ["default" => 0])]
    private ?\DateTime $deleteDate;

}