<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

use App\Repository\AliasDomainRepository;

#[ORM\Entity(repositoryClass: AliasDomainRepository::class)]
#[ORM\Table(name: "alias_domain")]
class AliasDomain
{
    #[ORM\Id]
    #[ORM\Column(type: "string", length: 255)]
    private string $domain;

    #[ORM\Column(type: "string", length: 255)]
    private string $targetDomain;

    #[ORM\Column(type: "boolean")]
    private bool $active;

    public function getDomain(): string
    {
        return $this->domain;
    }

    public function setDomain(string $domain): self
    {
        $this->domain = $domain;
        return $this;
    }

    public function getTargetDomain(): string
    {
        return $this->targetDomain;
    }

    public function setTargetDomain(string $targetDomain): self
    {
        $this->targetDomain = $targetDomain;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;
        return $this;
    }
}