<?php

/*
 * Senternal Hosting Control Panel
 * (c) Senternal LLC <http://www.senternal.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\DBAL\Types\Types;

use App\Repository\AdminRepository;

#[ORM\Entity(repositoryClass: AdminRepository::class)]
#[ORM\Table(name: "admin")]
class Admin
{
    #[ORM\Id]
    #[ORM\Column(type: "string", length: 255)]
    private string $username;

    #[ORM\Column(type: "string", length: 255)]
    private string $password;

    #[ORM\Column(type: "string", length: 255)]
    private string $name;

    #[ORM\Column(type: "string", length: 5)]
    private string $language;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, nullable: true, options: ["default" => 0])]
    private \DateTime $passwordLastChange;

    #[ORM\Column(type: "text", nullable: true)]
    private ?string $settings;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, nullable: true, options: ["default" => 0])]
    private \DateTime $created;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, nullable: true, options: ["default" => 0])]
    private \DateTime $modified;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, nullable: true, options: ["default" => 0])]
    private \DateTime $expired;

    #[ORM\Column(type: "boolean")]
    private bool $active;

    public function getUsername(): string
    {
        return $this->username;
    }

    public function setUsername(string $username): self
    {
        $this->username = $username;
        return $this;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;
        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;
        return $this;
    }

    public function getLanguage(): string
    {
        return $this->language;
    }

    public function setLanguage(string $language): self
    {
        $this->language = $language;
        return $this;
    }

    public function getPasswordLastChange(): \DateTime
    {
        return $this->passwordLastChange;
    }

    public function setPasswordLastChange(\DateTime $passwordLastChange): self
    {
        $this->passwordLastChange = $passwordLastChange;
        return $this;
    }

    public function getSettings(): ?string
    {
        return $this->settings;
    }

    public function setSettings(?string $settings): self
    {
        $this->settings = $settings;
        return $this;
    }

    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    public function setCreated(\DateTime $created): self
    {
        $this->created = $created;
        return $this;
    }

    public function getModified(): \DateTime
    {
        return $this->modified;
    }

    public function setModified(\DateTime $modified): self
    {
        $this->modified = $modified;
        return $this;
    }

    public function getExpired(): \DateTime
    {
        return $this->expired;
    }

    public function setExpired(\DateTime $expired): self
    {
        $this->expired = $expired;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;
        return $this;
    }
}