<?php

/*
 * Senternal Hosting Control Panel
 * (c) Senternal LLC <http://www.senternal.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace App\Controller\Domains;

use App\Entity\User;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

/**
 * Controller used to manage domains in the backend
 */
#[Route('/domains')]
#[IsGranted(User::ROLE_ADMIN)]
final class DomainsController extends AbstractController
{
    #[Route('/', name: 'domains_index', methods: ['GET'])]
    public function index(): Response
    {
        return $this->render('domains/index.html.twig');
    }

    #[Route('/new', name: 'domains_new', methods: ['GET', 'POST'])]
    public function add(): Response
    {
        return $this->render('domains/new.html.twig');
    }

    #[Route('/remove', name: 'domains_remove', methods: ['POST'])]
    public function delete(): Response
    {
        return $this->render('domains/delete.html.twig');
    }
}